import pandas as pd
from prince import FAMD
import matplotlib.pyplot as plt

# Corriger la variable 'caryotype' et créer le DataFrame
data = pd.DataFrame({
    'Age': [29, 43, 43, 30, 40, 35, 37, 26, 28, 43, 41, 35, 38, 39, 40, 41, 41, 37, 38, 24, 30, 38, 24, 40, 45, 33, 44, 33, 28, 26, 38, 31, 37, 36, 30, 40, 50, 33, 40, 36, 44, 40, 37, 35, 37],
    'antecedents': ['N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 'Y', 'N', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'Y', 'Y', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'N', 'Y', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', 'N', 'Y', 'N'],
    'CN': [4.2, 3.7, 4, 4.4, 5, 3.5, 8, 4.7, 3.7, 6, 4.8, 4.2, 3.6, 6.8, 5.4, 4.8, 5.2, 4, 5.7, 3.7, 5.6, 3.7, 6.1, 10, 8, 13, 3.7, 4, 5.4, 3.8, 4, 3.5, 3.7, 8.32, 9, 4.1, 10, 4.86, 5.8, 4, 3.8, 13, 10, 11.5, 6.7],
    'caryotype': ['Normal', 'Trisomie 21', 'Normal', 'Normal', 'Normal', 'Trisomie 21', 'Trisomie 21', 'Normal', 'Normal', 'Normal', 'Monosomie X', 'Trisomie 18', 'Normal', 'Normal', 'Trisomie 21', 'Normal', 'Normal', 'Trisomie 13', 'Normal', 'Normal', 'Normal', 'Normal', 'Monosomie X', 'Trisomie 18', 'Trisomie 13', 'Monosomie X', 'Normal', 'Normal', 'Deletion 8', 'Normal', 'Trisomie 21', 'Normal', 'Normal', 'Monosomie X', 'Trisomie 21', 'Normal', 'Trisomie 18', 'Trisomie 22', 'Trisomie 18', 'Normal', 'Trisomie 21', 'Trisomie 18', 'Monosomie X', 'Normal', 'Trisomie 21'],
    'Issue_grossesse': ['ACC_VB', 'MFIU', 'ACC_CS', 'ACC_VB', 'ACC_VB', 'IMG', 'IMG', 'EC', 'ACC_CS', 'ACC_VB', 'IMG', 'MFIU', 'ACC_VB', 'IMG', 'MFIU', 'ACC_VB', 'EC', 'IMG', 'MFIU', 'ACC_VB', 'ACC_VB', 'IMG', 'IMG', 'IMG', 'IMG', 'MFIU', 'ACC_VB', 'ACC_VB', 'MFIU', 'ACC_VB', 'IMG', 'ACC_VB', 'IMG', 'IMG', 'IMG', 'ACC_VB', 'IMG', 'IMG', 'IMG', 'ACC_VB', 'IMG', 'MFIU', 'IMG', 'IMG', 'MFIU']
})

# Appliquer l'AFDM
famd = FAMD(n_components=2, random_state=0)
famd.fit(data)

# Obtenir les coordonnées des individus et des variables
row_coords = famd.row_coordinates(data)
variable_coords = famd.column_correlations(data)

# Tracer les graphiques pour les individus
plt.figure(figsize=(10, 10))
plt.scatter(row_coords[0], row_coords[1])
plt.title("Représentation des Individus (Patientes)")
plt.xlabel("Dimension 1")
plt.ylabel("Dimension 2")
plt.show()

# Tracer les graphiques pour les variables
plt.figure(figsize=(10, 10))
plt.scatter(variable_coords[0], variable_coords[1])
plt.title("Représentation des Variables")
plt.xlabel("Dimension 1")
plt.ylabel("Dimension 2")
plt.show()
