import matplotlib.pyplot as plt
import seaborn as sns
import pandas as pd

# Charger les données à partir du fichier CSV fourni par l'utilisateur
file_path = 'C:/Users/Mohamed/OneDrive - Grand Hopital Est Francilien/Memoire DIU Medecine foetale/data/data_ANOVA.csv'
data_anomalies = pd.read_csv(file_path)

# Afficher les premières lignes du fichier pour vérifier la structure des données
print(data_anomalies.head())

# Tracer un boxplot pour visualiser les distributions de la CN par groupe
plt.figure(figsize=(10, 6))

# Utilisation d'un boxplot pour visualiser les distributions de la CN par groupe
sns.boxplot(x='Groupe', y='CN', data=data_anomalies, palette={"Normal": "green", "Anomalies": "red"})

# Ajouter des titres et labels
plt.title("Distribution de la Clarté Nucale par Groupe")
plt.xlabel("Groupe")
plt.ylabel("Clarté Nucale (mm)")

# Ajuster la graduation par unité
min_y = int(data_anomalies['CN'].min())
max_y = int(data_anomalies['CN'].max()) + 1  # Ajouter 1 pour inclure la dernière unité
plt.yticks(range(min_y, max_y + 1))

plt.grid(True)
plt.show()
